<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudAsset;

class AttachedResource extends \Google\Collection
{
  protected $collection_key = 'versionedResources';
  /**
   * The type of this attached resource. Example:
   * `osconfig.googleapis.com/Inventory` You can find the supported attached
   * asset types of each resource in this table:
   * `https://cloud.google.com/asset-inventory/docs/supported-asset-types`
   *
   * @var string
   */
  public $assetType;
  protected $versionedResourcesType = VersionedResource::class;
  protected $versionedResourcesDataType = 'array';

  /**
   * The type of this attached resource. Example:
   * `osconfig.googleapis.com/Inventory` You can find the supported attached
   * asset types of each resource in this table:
   * `https://cloud.google.com/asset-inventory/docs/supported-asset-types`
   *
   * @param string $assetType
   */
  public function setAssetType($assetType)
  {
    $this->assetType = $assetType;
  }
  /**
   * @return string
   */
  public function getAssetType()
  {
    return $this->assetType;
  }
  /**
   * Versioned resource representations of this attached resource. This is
   * repeated because there could be multiple versions of the attached resource
   * representations during version migration.
   *
   * @param VersionedResource[] $versionedResources
   */
  public function setVersionedResources($versionedResources)
  {
    $this->versionedResources = $versionedResources;
  }
  /**
   * @return VersionedResource[]
   */
  public function getVersionedResources()
  {
    return $this->versionedResources;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(AttachedResource::class, 'Google_Service_CloudAsset_AttachedResource');
