<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Datapipelines;

class GoogleCloudDatapipelinesV1Workload extends \Google\Model
{
  protected $dataflowFlexTemplateRequestType = GoogleCloudDatapipelinesV1LaunchFlexTemplateRequest::class;
  protected $dataflowFlexTemplateRequestDataType = '';
  protected $dataflowLaunchTemplateRequestType = GoogleCloudDatapipelinesV1LaunchTemplateRequest::class;
  protected $dataflowLaunchTemplateRequestDataType = '';

  /**
   * Template information and additional parameters needed to launch a Dataflow
   * job using the flex launch API.
   *
   * @param GoogleCloudDatapipelinesV1LaunchFlexTemplateRequest $dataflowFlexTemplateRequest
   */
  public function setDataflowFlexTemplateRequest(GoogleCloudDatapipelinesV1LaunchFlexTemplateRequest $dataflowFlexTemplateRequest)
  {
    $this->dataflowFlexTemplateRequest = $dataflowFlexTemplateRequest;
  }
  /**
   * @return GoogleCloudDatapipelinesV1LaunchFlexTemplateRequest
   */
  public function getDataflowFlexTemplateRequest()
  {
    return $this->dataflowFlexTemplateRequest;
  }
  /**
   * Template information and additional parameters needed to launch a Dataflow
   * job using the standard launch API.
   *
   * @param GoogleCloudDatapipelinesV1LaunchTemplateRequest $dataflowLaunchTemplateRequest
   */
  public function setDataflowLaunchTemplateRequest(GoogleCloudDatapipelinesV1LaunchTemplateRequest $dataflowLaunchTemplateRequest)
  {
    $this->dataflowLaunchTemplateRequest = $dataflowLaunchTemplateRequest;
  }
  /**
   * @return GoogleCloudDatapipelinesV1LaunchTemplateRequest
   */
  public function getDataflowLaunchTemplateRequest()
  {
    return $this->dataflowLaunchTemplateRequest;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudDatapipelinesV1Workload::class, 'Google_Service_Datapipelines_GoogleCloudDatapipelinesV1Workload');
