<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\SecurityCommandCenter;

class GoogleCloudSecuritycenterV2EnvironmentVariable extends \Google\Model
{
  /**
   * Environment variable name as a JSON encoded string.
   *
   * @var string
   */
  public $name;
  /**
   * Environment variable value as a JSON encoded string.
   *
   * @var string
   */
  public $val;

  /**
   * Environment variable name as a JSON encoded string.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * Environment variable value as a JSON encoded string.
   *
   * @param string $val
   */
  public function setVal($val)
  {
    $this->val = $val;
  }
  /**
   * @return string
   */
  public function getVal()
  {
    return $this->val;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudSecuritycenterV2EnvironmentVariable::class, 'Google_Service_SecurityCommandCenter_GoogleCloudSecuritycenterV2EnvironmentVariable');
